--- @generic T
--- @type fun(className: `T`): T
New = New -- Hack so autocompletion is possible using vscode and Lua extension (https://marketplace.visualstudio.com/items?itemName=sumneko.lua)

--- @type fun(scriptName: string): nil
CallLua = CallLua

--- @type fun(a: DynValue, typeName: string): boolean
IsOfType = IsOfType

--- @type fun(entitiesTypeName: string, luaTable: DynValue, addNullFirstElement?: boolean): any
CreateLuaEntityList = CreateLuaEntityList

--- @type fun(c1: Color, c2: Color, t: number): Color
ColorLerp = ColorLerp

---	@class SWorld_GenerationLua: SSingleton<SWorld_GenerationLua>
---		@field GenerateCities fun(nb: number, altitudeMin: number, distToPoles: number, distToLeftRight: number, distToMountains: number, distToOtherCities: number): nil
---		@field GenerateOre_PerCity_Dist fun(mineral: CItem_GroundMineral, nbFields: number, distToCitiesMin: number, distToCitiesMax: number, onOceans: boolean, nbHexesMin: number, nbHexesMax: number): nil
---		@field GenerateOre_Global_Dist fun(mineral: CItem_GroundMineral, nbFields: number, distToCitiesMin: number, onOceans: boolean, nbHexesMin: number, nbHexesMax: number): nil
---		@field GenerateOre_Global_Rate fun(mineral: CItem_GroundMineral, nbFields: number, distToCitiesMinRate: number, onOceans: boolean, nbHexesMin: number, nbHexesMax: number): nil
---		@field GenerateOre_Depleted fun(mineral: CItem_GroundMineral, nbToSwpawn: number): nil
---		@field GenerateOneContent fun(item: CItem_Content, supportItem: CItem_Ground, description: string): nil
SWorld_GenerationLua = SWorld_GenerationLua

---	@class SLoc: SSingleton<SLoc>
---		@field SetSentence fun(id: string, words: string[]): nil
---		@field GetLanguage fun(): LanguageName
---		@field Exists fun(id: string): boolean
---		@field GetOrNull fun(id: string, args: any[]): string
---		@field Get fun(id: string): string
---		@field Get fun(id: string, args: any[]): string
---		@field Localize fun(): nil
SLoc = SLoc

---	@class SEnvironmentFX: SSingleton<SEnvironmentFX>
SEnvironmentFX = SEnvironmentFX

---	@class SBomb: SSingleton<SBomb>
---		@field assetBombModel CAssetModel default value = nil
---		@field assetFxBombTrail CAssetModel default value = nil
---		@field contentShield CItem_ContentShield default value = nil
---		@field acceleration number
---		@field destructionRange number
---		@field altitudeBombSpawn number
---		@field shieldsCoords List<int2>
---		@field shieldVisibleLastFrame boolean
---		@field lastBombTime number
SBomb = SBomb

---	@class GAudio
---		@field audioSourceMusic AudioSource default value = nil
---		@field musics List<CAssetMusic> default value = nil
---		@field musicVolumeModifier number default value = 0.8
---		@field build CAssetSound default value = nil
---		@field buildError CAssetSound default value = nil
---		@field destroy CAssetSound default value = nil
---		@field destroyExplosion CAssetSound default value = nil
---		@field levelup CAssetSound default value = nil
---		@field dialog CAssetSound default value = nil
---		@field dynamite CAssetSound default value = nil
---		@field shipHorn CAssetSound default value = nil
---		@field cableBreak CAssetSound default value = nil
---		@field city CAssetSoundLooped default value = nil
---		@field desert CAssetSoundLooped default value = nil
---		@field extractors CAssetSoundLooped default value = nil
---		@field factories CAssetSoundLooped default value = nil
---		@field forest CAssetSoundLooped default value = nil
---		@field trains CAssetSoundLooped default value = nil
---		@field trucks CAssetSoundLooped default value = nil
---		@field ship CAssetSoundLooped default value = nil
---		@field sea CAssetSoundLooped default value = nil
---		@field ice CAssetSoundLooped default value = nil
---		@field space CAssetSoundLooped default value = nil
---		@field uiMenuPassby CAssetSound default value = nil
---		@field uiIconPassby CAssetSound default value = nil
---		@field uiLandmarkPassby CAssetSound default value = nil
---		@field uiOpen CAssetSound default value = nil
---		@field uiBack CAssetSound default value = nil
---		@field uiResume CAssetSound default value = nil
---		@field uiSelect CAssetSound default value = nil
---		@field uiPause CAssetSound default value = nil
---		@field uiIconSelect CAssetSound default value = nil
---		@field uiIconUnselect CAssetSound default value = nil
---		@field uiTooltip CAssetSound default value = nil
---		@field uiDialogOpen CAssetSound default value = nil
---		@field uiDialogClose CAssetSound default value = nil
---		@field uiDialogText CAssetSound default value = nil
---		@field uiEnhancedViewOn CAssetSound default value = nil
---		@field uiEnhancedViewOff CAssetSound default value = nil
---		@field uiEnhancedViewIdle CAssetSoundLooped default value = nil
---		@field uiEndgame CAssetSound default value = nil
---		@field spaceliftExplosion CAssetSound default value = nil
---		@field spaceliftBaseExplosion CAssetSoundLooped default value = nil
---		@field droneFlight CAssetSoundLooped default value = nil
---		@field missileAppears CAssetSound default value = nil
---		@field missileExplosionGround CAssetSound default value = nil
---		@field missileExplosionShield CAssetSound default value = nil
---		@field introWoosh CAssetSound default value = nil
---		@field LinearToLog fun(v: number): number
GAudio = GAudio

---	@class GCamera
---		@field focusPosition angles default value = (0, 1.611585, 0)
---		@field zoomLevelInitial number default value = 1
---		@field zoomDistances List<number> default value = { 10, 22, 42, 70, 170, 700, 1650, 2000, }
---		@field zoomAngles number[] default value = { 50, 40, 35, 30, 0, 0, 0, 0, }
---		@field zoomDepthOfField_Start number[] default value = { 12, 24, 47, 76, -1, -1, -1, -1, }
---		@field zoomDepthOfField_End number[] default value = { 13, 26, 50, 80, -1, -1, -1, -1, }
---		@field zoomDepthOfField_Radius number[] default value = { 2, 2, 1.5, 2, -1, -1, -1, -1, }
---		@field zoomDepthOfField_AnimalControlRadius number default value = 2
---		@field zoomDistance_DetailsVisible number default value = 70
---		@field zoomDistance_MeshVisible number default value = 170
---		@field shadowDistanceAdditional number default value = 0
---		@field zoomChangeSpeed number default value = 4
---		@field zoomChangeFadeDuration number default value = 0.5
---		@field zoomDistanceDragExact number default value = 200
---		@field scrollSpeed number default value = 40
---		@field slowCameraMult number default value = 0.1
---		@field debugRotateCameraIJKL boolean default value = False
---		@field camAngleMin number default value = 0.01
---		@field sunGOName string default value = "LightSun"
---		@field sunDeltaAngleY number default value = -70
---		@field sunAngleY number default value = 0
---		@field sunAngleYForced Nullable<number> default value = nil
---		@field zoomLevelTarget number default value = 1
---		@field zoomLogs number[] default value = nil
---		@field zoomLog number default value = 0
---		@field camDistance number default value = 0
---		@field camAngleCurrent number default value = 0
---		@field camAngleOffset Vector2 default value = (0.00, 0.00)
---		@field camera Camera default value = nil
---		@field cameraSkybox Camera default value = nil
---		@field camTransform Transform default value = nil
---		@field focusCoords int2 default value = int2<a href="/tp 0 0"><color=cyan>(0, 0)</color></a>
---		@field focusPositionLastFrame angles default value = (0, 0, 0)
---		@field focusPositionLastFrame2 angles default value = (0, 0, 0)
---		@field focusPositionVector3 Vector3 default value = (0.00, 0.00, 0.00)
GCamera = GCamera

---	@class GMouse
---		@field dragTrigger_PressDuration number default value = 0.2
---		@field dragTrigger_Distance number default value = 10
---		@field cursorDefault CCursor default value = nil
---		@field cursorScroll CCursor default value = nil
---		@field cursorScrollInvalid CCursor default value = nil
---		@field cursorBuild CCursor default value = nil
---		@field cursorBuildAnim CCursor default value = nil
---		@field cursorBuildInvalid CCursor default value = nil
---		@field cursorDelete CCursor default value = nil
---		@field cursorDeleteAnim CCursor default value = nil
---		@field cursorResizing CCursor default value = nil
---		@field dragSpeedMax number default value = 4
---		@field zoomInCentered boolean default value = False
GMouse = GMouse

---	@class GLoc
---		@field filename string default value = "Localization/PlanB_Localization.txt"
---		@field langages List<LanguageName> default value = { GLoc+LanguageName, GLoc+LanguageName, GLoc+LanguageName, GLoc+LanguageName, GLoc+LanguageName, GLoc+LanguageName, GLoc+LanguageName, GLoc+LanguageName, GLoc+LanguageName, GLoc+LanguageName, GLoc+LanguageName, GLoc+LanguageName, GLoc+LanguageName, GLoc+LanguageName, GLoc+LanguageName, GLoc+LanguageName, }
GLoc = GLoc

---	@class GOptions
---		@field musicVolume COptionFloat default value = COptionFloat
---		@field soundVolume COptionFloat default value = COptionFloat
---		@field musicDelay COptionFloat_MusicDelay default value = COptionFloat_MusicDelay
---		@field mouseLocked COptionBool_MouseLocked default value = COptionBool_MouseLocked
---		@field runInBackground COptionBool_RunInBackground default value = COptionBool_RunInBackground
---		@field language COptionList_Language default value = COptionList_Language
---		@field zoomOutCentered COptionBool default value = COptionBool
---		@field zoomSensitivity COptionList_ZoomSensitivity default value = COptionList_ZoomSensitivity
---		@field autoDestroyDepletedExtractors COptionBool default value = COptionBool
---		@field infosAutoOpen COptionBool default value = COptionBool
---		@field resolution_v2 COptionList_Resolution default value = COptionList_Resolution
---		@field fullscreen_v2 COptionList_Fullscreen2 default value = COptionList_Fullscreen2
---		@field uiScaling COptionFloat_UiScaling default value = COptionFloat_UiScaling
---		@field vsync COptionList_vSync default value = COptionList_vSync
---		@field fpsMax COptionList_fpsMax default value = COptionList_fpsMax
---		@field antialiasing COptionList_Antialiasing default value = COptionList_Antialiasing
---		@field hdr COptionBool_Hdr default value = COptionBool_Hdr
---		@field shadows COptionList_Shadows default value = COptionList_Shadows
---		@field itemsFx COptionBool_ItemsFx default value = COptionBool_ItemsFx
---		@field ambientOcclusion COptionBool_ambiantOcclusion default value = COptionBool_ambiantOcclusion
---		@field depthOfField COptionBool_depthOfField default value = COptionBool_depthOfField
---		@field animalViewDistance COption_AnimalViewDistance default value = COption_AnimalViewDistance
---		@field listOptions COption[][] default value = { { COptionFloat, COptionFloat, COptionFloat_MusicDelay, COptionBool_MouseLocked, COptionBool_RunInBackground, COptionList_Language, COptionBool, COptionList_ZoomSensitivity, COptionBool, COptionBool, }, { COptionList_Resolution, COptionList_Fullscreen2, COptionFloat_UiScaling, COptionList_vSync, COptionList_fpsMax, COptionList_Antialiasing, COptionBool_Hdr, COptionList_Shadows, COptionBool_ItemsFx, COptionBool_ambiantOcclusion, COptionBool_depthOfField, COption_AnimalViewDistance, }, nil, }
GOptions = GOptions

---	@class GPlanetOptions
---		@field mineralQuantityMult_PerOption number[] default value = { 2, 2, 1, 0.75, 0.5, }
---		@field waterInGroundInitialMult_PerOption number[] default value = { 0.15, 0.4, 1, 3, 4, }
---		@field objectiveForestMult_PerOption number[] default value = { 0.4, 0.7, 1, 1, 1, }
---		@field mountainsModifier_PerOption number[] default value = { 2, 1.2, 1, 0.75, 0.5, }
---		@field cityDegrowthLimit_PerOption number[] default value = { 0, 30, 50, 75, 100, }
---		@field resources CPlanetOption default value = GPlanetOptions+CPlanetOption
---		@field water CPlanetOption default value = GPlanetOptions+CPlanetOption
---		@field mountains CPlanetOption default value = GPlanetOptions+CPlanetOption
---		@field cityGrowth CPlanetOption default value = GPlanetOptions+CPlanetOption
---		@field listOptions CPlanetOption[] default value = { GPlanetOptions+CPlanetOption, GPlanetOptions+CPlanetOption, GPlanetOptions+CPlanetOption, GPlanetOptions+CPlanetOption, }
---		@field get_MineralsInfinite fun(): boolean
---		@field get_MineralsQuantityMult fun(): number
---		@field get_WaterInGroundInitialMult fun(): number
---		@field get_WaterInGroundInitial_WithOption fun(): number
---		@field get_ObjectiveForestMult fun(): number
---		@field get_MountainsModifier fun(): number
---		@field get_CityDegrowthLimit fun(): number
GPlanetOptions = GPlanetOptions

---	@class GEnvironmentFX
---		@field vehiclesAssetModel CAssetModels default value = nil
---		@field vehiclesSpeedRanges List<List<number>> default value = nil
---		@field vehiclePerTile number default value = 0.3
---		@field tractorAssetModel CAssetModel default value = nil
---		@field fxs List<FxOnHex> default value = nil
---		@field bird AnimalInfos default value = nil
---		@field animals List<AnimalInfos> default value = nil
---		@field animalsO2Pressure number default value = 8
---		@field nbAnimalsPerCamDistance number default value = 0.1
---		@field nbAnimalsMaxHighO2 number default value = 10
---		@field nbAnimalsMaxLowO2 number default value = 1
---		@field citiesCoord List<int2> default value = { }
---		@field farmCoords List<int2> default value = { }
GEnvironmentFX = GEnvironmentFX

---	@class GGame
---		@field levels List<CLevel> default value = nil
---		@field dialogs List<CDialog> default value = nil
---		@field characters List<CCharacter> default value = nil
---		@field infos List<CInfos> default value = nil
---		@field citiesInitialNb number default value = 1
---		@field populationMin number default value = 3
---		@field cityRecipesDuration_AtPop1 number default value = 120
---		@field cityRecipesDuration_DivEveryPopX10 number default value = 0.3333333
---		@field delayForPopGrow number default value = 15
---		@field delayForPopShrink number default value = 30
---		@field demoLevelMax number default value = 4
---		@field isV1_0 boolean default value = False
---		@field isPlaying boolean default value = False
---		@field debugInfos boolean default value = False
---		@field debugDevMode boolean default value = False
---		@field debugAllUnlocked boolean default value = False
---		@field hideUI boolean default value = False
---		@field hideUI_includeScene3D boolean default value = True
---		@field hideUI_includeOverlay boolean default value = True
---		@field isDemo boolean default value = False
---		@field isPGW boolean default value = False
---		@field isAnimalMode boolean default value = False
---		@field level CLevel default value = nil
---		@field cities List<CCity> default value = { }
---		@field population number default value = 0
---		@field statFloodedPop number default value = 0
---		@field statBombedPop number default value = 0
---		@field landmarks List<CLandmark> default value = { }
---		@field cityNames string[] default value = { "Tokyo", "Delhi", "Shanghai", "São Paulo", "Mexico City", "Cairo", "Mumbai", "Beijing", "Dhaka", "Osaka", "Karachi", "Buenos Aires", "Chongqing", "Istanbul", "Kolkata", "Manila", "Lagos", "Rio de Janeiro", "Tianjin", "Kinshasa", "Guangzhou", "Los Angeles", "Shenzhen", "Lahore", "Bangalore", "Paris", "Bogotá", "Jakarta", "Chennai", "Lima", "Bangkok", "Seoul", "Nagoya", "Hyderabad", "London", "Chicago", "Chengdu", "Nanjing", "Ho Chi Minh City", "Luanda", "Ahmedabad", "Kuala Lumpur", "Xi'an", "Hong Kong", "Dongguan", "Hangzhou", "Foshan", "Shenyang", "Riyadh", "Baghdad", "Santiago", "Surat", "Madrid", "Suzhou", "Pune", "Harbin", "Houston", "Dallas", "Toronto", "Dar es Salaam", "Miami", "Belo Horizonte", "Singapore", "Philadelphia", "Atlanta", "Fukuoka", "Khartoum", "Barcelona", "Johannesburg", "Saint Petersburg", "Qingdao", "Dalian", "Washington", "Yangon", "Alexandria", "Jinan", "Guadalajara", }
---		@field get_AllFree fun(): boolean
---		@field get_AllUnlocked fun(): boolean
GGame = GGame

---	@class GItems
---		@field defaultIconsFilename string default value = nil
---		@field items List<CItem> default value = nil
---		@field containersModels List<CAssetModelsContainers> default value = nil
---		@field itemsMountain CItem_Ground[] default value = nil
---		@field normalMountainCount number default value = 0
---		@field mountainVolcanoIndex number default value = 0
---		@field itemMountainDynamite CItem_GroundMountain default value = nil
---		@field decoModelsPerMountain CAssetModels[] default value = nil
---		@field itemDirt CItem_Ground default value = nil
---		@field itemGrass CItem_GroundGrass default value = nil
---		@field itemSF6 CItem default value = nil
---		@field itemNF3 CItem default value = nil
---		@field itemO2 CItem default value = nil
---		@field itemFactoryRecycle CItem default value = nil
---		@field itemDump CItem_ContentDump default value = nil
---		@field itemNei CItem_ContentNei default value = nil
---		@field itemTerrainLevel CItem_ContentFlattenTerrain default value = nil
---		@field itemTerrainSmooth CItem_ContentFlattenTerrain default value = nil
---		@field itemDynamite CItem_ContentDynamite default value = nil
---		@field itemPileOfDirt CItem_ContentPileOfDirt default value = nil
---		@field spaceliftBase CItem_ContentConstructionSite default value = nil
---		@field itemMultiSelectionDifferent CItem default value = nil
---		@field itemsCities CItem_ContentCity[] default value = nil
---		@field itemsCitiesDead CItem_ContentCityDead[] default value = nil
---		@field referenceMaterial CAssetMaterial default value = nil
---		@field containerStructureMaterial CAssetMaterial default value = nil
---		@field containerContentMaterial CAssetMaterial default value = nil
---		@field initialItems any[] default value = nil
---		@field depotMovePeriod number default value = 13
---		@field stockSingleStackMax number default value = 5
---		@field containersSpacing Vector3 default value = (0.10, 0.10, 0.30)
---		@field itemsMineralsLowLimit number default value = 0.1
---		@field itemsMineralsMediumLimit number default value = 0.3
---		@field refundItemsOnDestroy boolean default value = True
---		@field itemsDll CItemDll[] default value = nil
---		@field itemsDynamicCoords List<int2> default value = { }
---		@field itemsDynamicCoordsShuffled List<int2> default value = { }
---		@field dynamicUpdatesCount number default value = 0
---		@field simuPlanetTime_LastUpdate01s number default value = 0
---		@field simuPlanetTime_CurrentUpdate01s number default value = 0
GItems = GItems

---	@class GItemsUIGroups
---		@field uiGroups List<CItemUIGroup> default value = nil
---		@field defaultIconsFilename string default value = nil
---		@field itemGroupFavorites CItemUIGroup default value = nil
GItemsUIGroups = GItemsUIGroups

---	@class GScene3D
---		@field scene3DName string default value = "Scene3D"
---		@field uiWay_Width number default value = 0.17
---		@field uiWay_WidthPixelMin number default value = 3
---		@field uiLineAltitude number default value = 0.1
---		@field hexSelection_DistInt number default value = 0.15
---		@field hexDepotRange_DistInt number default value = 0.3
---		@field stopDest_DistInt number default value = 0.8
---		@field stopDest_DistExt number default value = 0.5
---		@field hexMouseover_dotted number default value = 0.6
---		@field stopDestinationMouseover_dotted number default value = 0.4
---		@field VehiclesOverlayInZoomInter boolean default value = True
---		@field dragTrigger_PressDuration number default value = 0.15
---		@field rectTrigger_PressDistance number default value = 5
---		@field doubleClickTrigger_timeInterval number default value = 0.25
---		@field mouseMovedHex boolean default value = False
---		@field mouseoverCoords int2 default value = int2<a href="/tp 0 0"><color=cyan>(0, 0)</color></a>
---		@field mouseoverCoordsLastFrame int2 default value = int2<a href="/tp 0 0"><color=cyan>(0, 0)</color></a>
---		@field mouseoverLines List<CLine> default value = { }
---		@field actionMode number default value = None
---		@field isLastBuildValid boolean default value = False
---		@field debugCtrlRange number default value = 1
---		@field isRangeBuilding boolean default value = False
---		@field fxParentGO Transform default value = nil
---		@field camSkybox Camera default value = nil
GScene3D = GScene3D

---	@class GSceneHud
---		@field tooltipDelay number default value = 0.2
---		@field speeds number[] default value = { 0, 1, 2.5, 5, }
---		@field groupInBarSelected CItemUIGroup default value = nil
---		@field itemInBarSelected CItem default value = nil
---		@field itemGroupsInBar List<CItemUIGroup> default value = { }
GSceneHud = GSceneHud

---	@class GSceneUIOverlay
---		@field loadingTipDuration number default value = 5
---		@field loadingTipInitialWait number default value = 1
GSceneUIOverlay = GSceneUIOverlay

---	@class GDrones
---		@field searchPeriod number default value = 1.5
---		@field speed number default value = 2.3
---		@field durationTakeOff number default value = 0.4
---		@field durationFor2Containers number default value = 0.2
---		@field acceleration number default value = 5
---		@field altitudeMin number default value = 0.2
---		@field altitudeMax number default value = 1.5
---		@field modelDrone CAssetModel default value = nil
---		@field modelDroneSimple CAssetModel default value = nil
---		@field drones List<CDrone> default value = { }
---		@field modelsPool CPoolModels<CDrone> default value = CPoolModels`1[CDrone]
---		@field modelsSimplePool CPoolModels<CDrone> default value = CPoolModels`1[CDrone]
---		@field neisRef_Even List<int2>[] default value = { { int2<a href="/tp 0 0"><color=cyan>(0, 0)</color></a>, int2<a href="/tp 1 0"><color=cyan>(1, 0)</color></a>, int2<a href="/tp 0 1"><color=cyan>(0, 1)</color></a>, int2<a href="/tp -1 1"><color=cyan>(-1, 1)</color></a>, int2<a href="/tp -1 0"><color=cyan>(-1, 0)</color></a>, int2<a href="/tp -1 -1"><color=cyan>(-1, -1)</color></a>, int2<a href="/tp 0 -1"><color=cyan>(0, -1)</color></a>, }, { int2<a href="/tp 0 0"><color=cyan>(0, 0)</color></a>, int2<a href="/tp 1 0"><color=cyan>(1, 0)</color></a>, int2<a href="/tp 0 1"><color=cyan>(0, 1)</color></a>, int2<a href="/tp -1 1"><color=cyan>(-1, 1)</color></a>, int2<a href="/tp -1 0"><color=cyan>(-1, 0)</color></a>, int2<a href="/tp -1 -1"><color=cyan>(-1, -1)</color></a>, int2<a href="/tp 0 -1"><color=cyan>(0, -1)</color></a>, int2<a href="/tp 2 0"><color=cyan>(2, 0)</color></a>, int2<a href="/tp 1 1"><color=cyan>(1, 1)</color></a>, int2<a href="/tp 1 -1"><color=cyan>(1, -1)</color></a>, int2<a href="/tp 1 2"><color=cyan>(1, 2)</color></a>, int2<a href="/tp 0 2"><color=cyan>(0, 2)</color></a>, int2<a href="/tp -1 2"><color=cyan>(-1, 2)</color></a>, int2<a href="/tp -2 1"><color=cyan>(-2, 1)</color></a>, int2<a href="/tp -2 0"><color=cyan>(-2, 0)</color></a>, int2<a href="/tp -2 -1"><color=cyan>(-2, -1)</color></a>, int2<a href="/tp -1 -2"><color=cyan>(-1, -2)</color></a>, int2<a href="/tp 0 -2"><color=cyan>(0, -2)</color></a>, int2<a href="/tp 1 -2"><color=cyan>(1, -2)</color></a>, }, { int2<a href="/tp 0 0"><color=cyan>(0, 0)</color></a>, int2<a href="/tp 1 0"><color=cyan>(1, 0)</color></a>, int2<a href="/tp 0 1"><color=cyan>(0, 1)</color></a>, int2<a href="/tp -1 1"><color=cyan>(-1, 1)</color></a>, int2<a href="/tp -1 0"><color=cyan>(-1, 0)</color></a>, int2<a href="/tp -1 -1"><color=cyan>(-1, -1)</color></a>, int2<a href="/tp 0 -1"><color=cyan>(0, -1)</color></a>, int2<a href="/tp 2 0"><color=cyan>(2, 0)</color></a>, int2<a href="/tp 1 1"><color=cyan>(1, 1)</color></a>, int2<a href="/tp 1 -1"><color=cyan>(1, -1)</color></a>, int2<a href="/tp 1 2"><color=cyan>(1, 2)</color></a>, int2<a href="/tp 0 2"><color=cyan>(0, 2)</color></a>, int2<a href="/tp -1 2"><color=cyan>(-1, 2)</color></a>, int2<a href="/tp -2 1"><color=cyan>(-2, 1)</color></a>, int2<a href="/tp -2 0"><color=cyan>(-2, 0)</color></a>, int2<a href="/tp -2 -1"><color=cyan>(-2, -1)</color></a>, int2<a href="/tp -1 -2"><color=cyan>(-1, -2)</color></a>, int2<a href="/tp 0 -2"><color=cyan>(0, -2)</color></a>, int2<a href="/tp 1 -2"><color=cyan>(1, -2)</color></a>, int2<a href="/tp 3 0"><color=cyan>(3, 0)</color></a>, int2<a href="/tp 2 1"><color=cyan>(2, 1)</color></a>, int2<a href="/tp 2 -1"><color=cyan>(2, -1)</color></a>, int2<a href="/tp 2 2"><color=cyan>(2, 2)</color></a>, int2<a href="/tp 2 -2"><color=cyan>(2, -2)</color></a>, int2<a href="/tp 1 3"><color=cyan>(1, 3)</color></a>, int2<a href="/tp 0 3"><color=cyan>(0, 3)</color></a>, int2<a href="/tp -1 3"><color=cyan>(-1, 3)</color></a>, int2<a href="/tp -2 3"><color=cyan>(-2, 3)</color></a>, int2<a href="/tp -2 2"><color=cyan>(-2, 2)</color></a>, int2<a href="/tp -3 1"><color=cyan>(-3, 1)</color></a>, int2<a href="/tp -3 0"><color=cyan>(-3, 0)</color></a>, int2<a href="/tp -3 -1"><color=cyan>(-3, -1)</color></a>, int2<a href="/tp -2 -2"><color=cyan>(-2, -2)</color></a>, int2<a href="/tp -2 -3"><color=cyan>(-2, -3)</color></a>, int2<a href="/tp -1 -3"><color=cyan>(-1, -3)</color></a>, int2<a href="/tp 0 -3"><color=cyan>(0, -3)</color></a>, int2<a href="/tp 1 -3"><color=cyan>(1, -3)</color></a>, }, }
---		@field neisRef_Odd List<int2>[] default value = { { int2<a href="/tp 0 0"><color=cyan>(0, 0)</color></a>, int2<a href="/tp 1 0"><color=cyan>(1, 0)</color></a>, int2<a href="/tp 1 1"><color=cyan>(1, 1)</color></a>, int2<a href="/tp 0 1"><color=cyan>(0, 1)</color></a>, int2<a href="/tp -1 0"><color=cyan>(-1, 0)</color></a>, int2<a href="/tp 0 -1"><color=cyan>(0, -1)</color></a>, int2<a href="/tp 1 -1"><color=cyan>(1, -1)</color></a>, }, { int2<a href="/tp 0 0"><color=cyan>(0, 0)</color></a>, int2<a href="/tp 1 0"><color=cyan>(1, 0)</color></a>, int2<a href="/tp 1 1"><color=cyan>(1, 1)</color></a>, int2<a href="/tp 0 1"><color=cyan>(0, 1)</color></a>, int2<a href="/tp -1 0"><color=cyan>(-1, 0)</color></a>, int2<a href="/tp 0 -1"><color=cyan>(0, -1)</color></a>, int2<a href="/tp 1 -1"><color=cyan>(1, -1)</color></a>, int2<a href="/tp 2 0"><color=cyan>(2, 0)</color></a>, int2<a href="/tp 2 1"><color=cyan>(2, 1)</color></a>, int2<a href="/tp 2 -1"><color=cyan>(2, -1)</color></a>, int2<a href="/tp 1 2"><color=cyan>(1, 2)</color></a>, int2<a href="/tp 0 2"><color=cyan>(0, 2)</color></a>, int2<a href="/tp -1 2"><color=cyan>(-1, 2)</color></a>, int2<a href="/tp -1 1"><color=cyan>(-1, 1)</color></a>, int2<a href="/tp -2 0"><color=cyan>(-2, 0)</color></a>, int2<a href="/tp -1 -1"><color=cyan>(-1, -1)</color></a>, int2<a href="/tp -1 -2"><color=cyan>(-1, -2)</color></a>, int2<a href="/tp 0 -2"><color=cyan>(0, -2)</color></a>, int2<a href="/tp 1 -2"><color=cyan>(1, -2)</color></a>, }, { int2<a href="/tp 0 0"><color=cyan>(0, 0)</color></a>, int2<a href="/tp 1 0"><color=cyan>(1, 0)</color></a>, int2<a href="/tp 1 1"><color=cyan>(1, 1)</color></a>, int2<a href="/tp 0 1"><color=cyan>(0, 1)</color></a>, int2<a href="/tp -1 0"><color=cyan>(-1, 0)</color></a>, int2<a href="/tp 0 -1"><color=cyan>(0, -1)</color></a>, int2<a href="/tp 1 -1"><color=cyan>(1, -1)</color></a>, int2<a href="/tp 2 0"><color=cyan>(2, 0)</color></a>, int2<a href="/tp 2 1"><color=cyan>(2, 1)</color></a>, int2<a href="/tp 2 -1"><color=cyan>(2, -1)</color></a>, int2<a href="/tp 1 2"><color=cyan>(1, 2)</color></a>, int2<a href="/tp 0 2"><color=cyan>(0, 2)</color></a>, int2<a href="/tp -1 2"><color=cyan>(-1, 2)</color></a>, int2<a href="/tp -1 1"><color=cyan>(-1, 1)</color></a>, int2<a href="/tp -2 0"><color=cyan>(-2, 0)</color></a>, int2<a href="/tp -1 -1"><color=cyan>(-1, -1)</color></a>, int2<a href="/tp -1 -2"><color=cyan>(-1, -2)</color></a>, int2<a href="/tp 0 -2"><color=cyan>(0, -2)</color></a>, int2<a href="/tp 1 -2"><color=cyan>(1, -2)</color></a>, int2<a href="/tp 3 0"><color=cyan>(3, 0)</color></a>, int2<a href="/tp 3 1"><color=cyan>(3, 1)</color></a>, int2<a href="/tp 3 -1"><color=cyan>(3, -1)</color></a>, int2<a href="/tp 2 2"><color=cyan>(2, 2)</color></a>, int2<a href="/tp 2 -2"><color=cyan>(2, -2)</color></a>, int2<a href="/tp 2 3"><color=cyan>(2, 3)</color></a>, int2<a href="/tp 1 3"><color=cyan>(1, 3)</color></a>, int2<a href="/tp 0 3"><color=cyan>(0, 3)</color></a>, int2<a href="/tp -1 3"><color=cyan>(-1, 3)</color></a>, int2<a href="/tp -2 2"><color=cyan>(-2, 2)</color></a>, int2<a href="/tp -2 1"><color=cyan>(-2, 1)</color></a>, int2<a href="/tp -3 0"><color=cyan>(-3, 0)</color></a>, int2<a href="/tp -2 -1"><color=cyan>(-2, -1)</color></a>, int2<a href="/tp -2 -2"><color=cyan>(-2, -2)</color></a>, int2<a href="/tp -1 -3"><color=cyan>(-1, -3)</color></a>, int2<a href="/tp 0 -3"><color=cyan>(0, -3)</color></a>, int2<a href="/tp 1 -3"><color=cyan>(1, -3)</color></a>, int2<a href="/tp 2 -3"><color=cyan>(2, -3)</color></a>, }, }
GDrones = GDrones

---	@class GColors
---		@field colorWhite CColor default value = CColor
---		@field colorBlack CColor default value = CColor
---		@field colorOK CColor default value = CColor
---		@field colorInvalid CColor default value = CColor
---		@field colorWarning CColor default value = CColor
---		@field colorCityStable CColor default value = CColor
---		@field colorNeedShift CColor default value = CColor
---		@field colorOK_Alpha CColor default value = CColor
---		@field colorInvalid_Alpha CColor default value = CColor
---		@field colorNeedShift_Alpha CColor default value = CColor
---		@field colorOK_ItemOwnedMax CColor default value = CColor
---		@field colorInvalid_ItemOwnedMax CColor default value = CColor
---		@field colorDestroy CColor default value = CColor
---		@field colorInvalidWay CColor default value = CColor
---		@field colorValidWay CColor default value = CColor
---		@field hexSelected CColor default value = CColor
---		@field hexOver CColor default value = CColor
---		@field hexDepotRange_Exterior CColor default value = CColor
---		@field hexDepotRange_Interior CColor default value = CColor
---		@field hexInvalid CColor default value = CColor
---		@field lineUiSelection CColor default value = CColor
---		@field lineSelected CColor default value = CColor
---		@field lineOver CColor default value = CColor
---		@field lineOverInvalid CColor default value = CColor
---		@field waterflowRisk CColor default value = CColor
---		@field waterflowNoRisk CColor default value = CColor
---		@field colorItemUnassigned CColor default value = CColor
---		@field inputDuplicatedText CColor default value = CColor
---		@field highlight CColor default value = CColor
---		@field colorTextWhite CColor default value = CColor
---		@field colorTextDark CColor default value = CColor
---		@field colorChartWaterMax CColor default value = CColor
---		@field colorChartWaterMin CColor default value = CColor
---		@field colorChartOxygenMax CColor default value = CColor
---		@field colorChartOxygenMin CColor default value = CColor
---		@field colorPopupItemInRange CColor default value = CColor
GColors = GColors

---	@class GView
---		@field colorsGroundAltitudes number[] default value = { 0, 2, 7, 50, }
---		@field colorsGround CColor[] default value = { CColor, CColor, CColor, CColor, }
---		@field colorSand CColor default value = CColor
---		@field colorGroundVariation number default value = 0.015
---		@field waterDeepFoamMin number default value = 0.5
---		@field waterDeep number default value = 0.1
---		@field waterDisplay_margins number default value = 15
---		@field waterDisplay_distanceReset number default value = 10
---		@field waterDisplay_margins2 number default value = 5
---		@field waterflow_Minimum number default value = 1000
---		@field waterflow_yOffset number default value = 0.05
---		@field waterflow_Arrows_SizeMin number default value = 0.1
---		@field waterflow_Arrows_SizeMax number default value = 0.25
---		@field waterflow_Lines_SizeMin number default value = 0.02
---		@field waterflow_Lines_SizeMax number default value = 0.06
---		@field waterflow_Triangles_Size number default value = 0.15
---		@field colorWorldWater_GradientStart CColor default value = CColor
---		@field colorWorldWater_GradientEnd CColor default value = CColor
---		@field colorWorldWater_GradientDepthStart number default value = 0.1
---		@field colorWorldWater_GradientDepthFadeEnd number default value = 2
---		@field colorWorldWater_FadeDepthStart number default value = -0.5
---		@field colorWorldWater_FadeDepthEnd number default value = 1
---		@field colorIce CColor default value = CColor
GView = GView

---	@class GViewBlocks
---		@field viewSizeYparam number default value = 50
---		@field blocksBufferCount number default value = 8
---		@field mountainRange_1ext MountainParamsRange default value = GViewBlocks+MountainParamsRange
---		@field mountainRange_1int MountainParamsRange default value = GViewBlocks+MountainParamsRange
---		@field mountainRange_7ext MountainParamsRange default value = GViewBlocks+MountainParamsRange
---		@field mountainRange_7int MountainParamsRange default value = GViewBlocks+MountainParamsRange
---		@field mountainRangesPerData MountainParamsRange[] default value = { nil, GViewBlocks+MountainParamsRange, GViewBlocks+MountainParamsRange, GViewBlocks+MountainParamsRange, nil, GViewBlocks+MountainParamsRange, nil, nil, }
---		@field viewSize int2 default value = int2<a href="/tp 0 0"><color=cyan>(0, 0)</color></a>
---		@field nbTerrainVerticesMaxPerBlock number default value = 0
---		@field nbTerrainTrianglesMaxPerBlock number default value = 0
GViewBlocks = GViewBlocks

---	@class GViewWorld
---		@field rockRandomness number default value = 0.1
---		@field textureSize number default value = 0
GViewWorld = GViewWorld

---	@class GBlocks
---		@field sizeTargetAtEquator number default value = 50
---		@field blocks CBlock[] default value = nil
---		@field nbBlocks int2 default value = int2<a href="/tp 0 0"><color=cyan>(0, 0)</color></a>
---		@field blockSizeMax int2 default value = int2<a href="/tp 0 0"><color=cyan>(0, 0)</color></a>
GBlocks = GBlocks

---	@class GHexes
---		@field flags number[] default value = nil
---		@field pos Vector3[] default value = nil
---		@field altitude number[] default value = nil
---		@field altitudePreview number[] default value = nil
---		@field altitudePreviewHexType number[] default value = nil
---		@field upVector Vector3[] default value = nil
---		@field normal Vector3[] default value = nil
---		@field slopeMax number[] default value = nil
---		@field groundId number[] default value = nil
---		@field groundData number[] default value = nil
---		@field contentId number[] default value = nil
---		@field contentData number[] default value = nil
---		@field water number[] default value = nil
---		@field stacks CStacks[] default value = nil
---		@field version number[] default value = nil
---		@field pf_G number[] default value = nil
---		@field pf_ParentDir number[] default value = nil
---		@field temp number[] default value = nil
---		@field debug Color[] default value = nil
---		@field indexesRandom number[] default value = nil
---		@field waterflow number[] default value = nil
---		@field modelsContent List<Transform>[] default value = nil
---		@field modelsGround List<Transform>[] default value = nil
---		@field modelsContainers List<Transform>[] default value = nil
---		@field modelsLoadedCounter number[] default value = nil
---		@field HasFlag fun(coords: int2, flag: number): boolean
---		@field SetFlag fun(coords: int2, flag: number, value: boolean): nil
---		@field IsHex fun(coords: int2): boolean
---		@field IsMountain fun(coords: int2): boolean
---		@field IsHexStandard fun(coords: int2): boolean
---		@field GetWaterProximity fun(coords: int2): number
---		@field SetWaterProximity fun(coords: int2, value: number): nil
---		@field GetMountainType fun(coords: int2): number
---		@field SetMountainType fun(coords: int2, value: number): nil
---		@field ContentId fun(coords: int2): number
---		@field ContentData fun(coords: int2): number
---		@field GroundId fun(coords: int2): number
---		@field GroundData fun(coords: int2): number
---		@field Version fun(coords: int2): number
---		@field UpVector fun(coords: int2): Vector3
---		@field Pos fun(coords: int2): Vector3
---		@field SetContentId fun(coords: int2, value: number): nil
---		@field SetContentData fun(coords: int2, value: number): nil
---		@field SetGroundId fun(coords: int2, value: number): nil
---		@field SetGroundData fun(coords: int2, value: number): nil
---		@field SetVersion fun(coords: int2, value: number): nil
---		@field SetUpVector fun(coords: int2, value: Vector3): nil
GHexes = GHexes

---	@class GPF
---		@field pfInt_NbList number default value = 150
GPF = GPF

---	@class GPlanet
---		@field dayDuration number default value = 1
---		@field daysPerYear number default value = 300
---		@field monthsPerYear number default value = 12
---		@field planetInclinationMax number default value = 20
---		@field tempMinInitial number default value = -100
---		@field tempDeltaSunshine number default value = 60
---		@field waterStartTemp number default value = -20
---		@field waterEndTemp number default value = 10
---		@field sf6_PressurePerContainer number default value = 6.66666666666667E-07
---		@field nf3_PressurePerContainer number default value = 6.66666666666667E-07
---		@field o2_PressurePerTree number default value = 3.33333333333333E-05
---		@field SF6_Power number default value = 45.05
---		@field NF3_Power number default value = 25.05
---		@field name string default value = nil
---		@field dailySF6 List<number> default value = { }
---		@field dailyNF3 List<number> default value = { }
---		@field dailyO2 List<number> default value = { }
---		@field dailyTemperature List<number> default value = { }
---		@field temperatures number[] default value = nil
---		@field temperaturesMin number[] default value = nil
---		@field temperaturesMax number[] default value = nil
---		@field temperaturesAverage number[] default value = nil
---		@field temperatureInitialAverage number default value = -57.3
---		@field sf6_NbContainersInAtm number default value = 0
---		@field nf3_NbContainersInAtm number default value = 0
---		@field o2_NbTrees number default value = 0
---		@field temperatureRise number default value = 0
GPlanet = GPlanet

---	@class GWater
---		@field waterInGroundInitial number default value = 300000
---		@field waterDepthMin number default value = 0.01
---		@field waterWetDepthMin number default value = 0.0001
---		@field rainSpeedMountains number default value = 2E-05
---		@field rainSpeedMin number default value = 2E-07
---		@field rainSpeedCloudMult number default value = 1E-05
---		@field groundWaterEvaporationSpeed number default value = 4E-05
---		@field waterEvaporationSpeed number default value = 8E-06
---		@field waterInGroundEvaporated number default value = 0
---		@field waterPumped number default value = 0
---		@field cloudsGridSize int2 default value = int2<a href="/tp 0 0"><color=cyan>(0, 0)</color></a>
---		@field cloudsGrid number[] default value = nil
---		@field cloudsNeis int2[] default value = nil
---		@field windAngle number[] default value = nil
---		@field dispersionAngle number default value = 300
---		@field neisAngle number[] default value = { -135, -90, -45, -180, 0, 135, 90, 45, }
GWater = GWater

---	@class GWorld
---		@field sizeX number default value = 2048
---		@field nbSlices number default value = 16
---		@field altitudeMaxMountain number default value = 30
---		@field altitudeMaxAbsolute number default value = 50
---		@field angleMountain number default value = 20
---		@field angleMountain_TerrainTool number default value = 35
---		@field smoothing_maxAltitude number default value = 10
---		@field smoothing_minDelta number default value = 5
---		@field hexSizeInMeter number default value = 100
---		@field mountainsQuantityRatios number[] default value = { 0.5, 0.2, 0.3, }
---		@field mountainsHeights number[] default value = { 4, 15, 30, }
---		@field platesCenterAltMax number default value = 2
---		@field mountainRatio_Mountain number default value = 0.4
---		@field mountainRatio_Transition number default value = 0.3
---		@field randomSeed number default value = -1
---		@field debugGenerationColors boolean default value = False
---		@field debugGenerationCamera boolean default value = False
---		@field debugGenerationWaterAlt number default value = 0
---		@field hexesVersionCounter number default value = 0
---		@field worldRadius number default value = 0
---		@field size int2 default value = int2<a href="/tp 0 0"><color=cyan>(0, 0)</color></a>
---		@field rowsMin number[] default value = nil
---		@field rowsMax number[] default value = nil
---		@field triHeight number default value = 0.8660254
---		@field triAlpha number default value = 0
---		@field triBeta number default value = 0
---		@field sliceWidth number default value = 0
---		@field sliceLeft number[] default value = nil
---		@field sliceRight number[] default value = nil
---		@field sliceFull_Width number[] default value = nil
---		@field sliceFull_Separation number[] default value = nil
---		@field nbHexes number default value = 0
---		@field randomSeedUsed number default value = -1
GWorld = GWorld

---	@class Color: ValueType
---		@field r number
---		@field g number
---		@field b number
---		@field a number

---	@class Vector3: ValueType
---		@field kEpsilon number default value = 1E-05
---		@field kEpsilonNormalSqrt number default value = 1E-15
---		@field x number
---		@field y number
---		@field z number

---	@class List<T>

---	@class CCursor: CLuaEntity
---		@field hotspot int2
---		@field animationSpeed number
---		@field textures2D CAssetTexture2D[]

---	@class CAssetBase: CLuaEntity
---		@field waitForLoad boolean

---	@class CAsset<T>: CAssetBase

---	@class CAssetFile<T>: CAsset<T>
---		@field fileName string

---	@class CAssetAudio: CAssetFile<AudioClip>

---	@class CAssetMusic: CAssetAudio
---		@field bonusRandom number
---		@field bonus number
---		@field bonusMenu number[]
---		@field bonusLevelUp number[]
---		@field only_v10 boolean

---	@class CAssetSound: CAssetBase
---		@field volume number
---		@field pitchVariation number
---		@field minDelay number
---		@field playableInIntro boolean
---		@field clips List<CAssetAudio>

---	@class CAssetSoundLooped: CAssetAudio
---		@field volume number
---		@field audioSource AudioSource
---		@field sources List<Source>
---		@field spread number
---		@field minDistance number
---		@field maxDistance number
---		@field rolloffMode number
---		@field zoomLevelVolume number[]
---		@field playFromSpace boolean

---	@class CAssetImage<T>: CAssetFile<T>

---	@class CAssetTexture2D: CAssetImage<Texture2D>

---	@class CAssetSprite: CAssetImage<Sprite>
---		@field spriteName string

---	@class CAssetMaterial: CAssetFile<Material>

---	@class CAssetModel: CAssetFile<GameObject>
---		@field scale Vector3

---	@class CAssetModels: CAssetBase
---		@field probas List<number>
---		@field models List<CAssetModel>

---	@class CAssetModelsContainers: CAssetModels
---		@field depotMeshes List<ValueTuple<Mesh, Mesh>>
---		@field containerShipMeshes ValueTuple<Mesh, Mesh>
---		@field containerMeshName string
---		@field contentMeshName string

---	@class CCharacter: CLuaEntity
---		@field yearsBeforeAging number
---		@field faceTypeElements List<FaceElements>
---		@field eyeClosed CAssetSprite
---		@field mouthClosed CAssetSprite
---		@field animate boolean

---	@class CInfos: CLuaEntity
---		@field openCondition CCondition
---		@field icon CAssetSprite

---	@class CLuaEntity
---		@field codeListName string
---		@field codeName string
---		@field id number

---	@class CSentence
---		@field id string
---		@field line string
---		@field words List<string>
---		@field translation string

---	@class AnimalInfos: CLuaEntity
---		@field model CAssetModel
---		@field canFly boolean
---		@field speedMin number
---		@field speedMax number
---		@field speedControlWalk number
---		@field speedControlRun number
---		@field rotationSpeed number
---		@field temperatureMin number
---		@field temperatureMax number
---		@field o2Minimum number
---		@field contentsToSpawnOn List<CItem_Content>
---		@field groundsToSpawnOn List<CItem_Ground>
---		@field canDestroyBuildings boolean
---		@field soundOnSelect CAssetSound
---		@field sound CAssetSound
---		@field soundDelayMin number
---		@field soundDelayMax number

---	@class CCondition

---	@class CCondition_Int: CCondition

---	@class CCondition_Warmer: CCondition
---		@field degrees number

---	@class CCondition_Pop: CCondition_Int
---		@field population number

---	@class CCondition_EndOfBeta: CCondition

---	@class CCondition_EndGame: CCondition

---	@class CCondition_LevelFinished: CCondition
---		@field level CLevel
---		@field checkOnLaterLevels boolean

---	@class CCondition_LevelReached: CCondition
---		@field level CLevel

---	@class CCondition_ProduceMultiple: CCondition_Int
---		@field item CItem_Content
---		@field count number
---		@field itemFactory CItem_Content

---	@class CCondition_FinishSpaceLiftRecipe: CCondition_Int

---	@class CCondition_SpaceLiftRobbery: CCondition_Int
---		@field spacelift CItem_ContentSpaceLift

---	@class CCondition_ShieldUp: CCondition_Int

---	@class CCondition_ShieldPopDialog: CCondition_Int
---		@field conditionShieldUp boolean
---		@field conditionPop number
---		@field conditionDialog CDialog
---		@field conditionDialogComplete boolean
---		@field conditionAnotherDialogUncomplete CDialog

---	@class CCondition_PopBombed: CCondition_Int

---	@class CCondition_TemperatureTooLow: CCondition_Int
---		@field levelAt CLevel
---		@field levelProgress number
---		@field temperatureIncreaseMax number

---	@class CCondition_TreesAmountTooLow: CCondition_Int
---		@field levelAt CLevel
---		@field levelProgress number
---		@field treesAmountMax number

---	@class CCondition_Oxygen: CCondition
---		@field oxygen number
---		@field only_v1 boolean

---	@class CDialog: CLuaEntity
---		@field textLocalized string
---		@field character CCharacter
---		@field openCondition CCondition
---		@field completeOnRead boolean
---		@field isComplete boolean
---		@field characterFaceId number
---		@field visibleInLevel number
---		@field waitAfterBomb number
---		@field onDialogComplete CDialogAnimation

---	@class CDialogAnimation_TpOnSpaceLift: CDialogAnimation

---	@class CDialogAnimation_SpaceLiftExplosion: CDialogAnimation

---	@class CDialogAnimation_CityBombing: CDialogAnimation

---	@class CDialogAnimation_ObjectiveChangedMessage: CDialogAnimation

---	@class CDialogAnimation_AchCityProtection: CDialogAnimation

---	@class CLevel: CLuaEntity
---		@field levelNumber number
---		@field unlockItems List<CItem>
---		@field objective CCondition
---		@field temporaryObjective CCondition
---		@field temporaryObjective_DialogRequiredOn CDialog
---		@field temporaryObjective_DialogRequiredOff CDialog
---		@field spaceLift_Placed boolean
---		@field spaceLift_RecipeIndex number
---		@field spaceLift_AutodestroyWhenLevelComplete boolean

---	@class FxOnHex: CLuaEntity
---		@field models CAssetModels
---		@field proba number
---		@field isEmittingSingleParticles boolean
---		@field spawnWindFactor number
---		@field spawnAltitudeMin number
---		@field spawnAltitudeMax number
---		@field spawnOnIce boolean
---		@field spawnOnTreeDead boolean
---		@field spawnOnTreeWinter boolean
---		@field spawnOnTreeFall boolean
---		@field spawnOnTreeSpringSummer boolean
---		@field useGroundColor boolean
---		@field waterMin number
---		@field waterMax number
---		@field zoomMin number
---		@field zoomMax number
---		@field spawnOnItems List<CItem>

---	@class CItem: CLuaEntity
---		@field uiGroup CItemUIGroup
---		@field icon CAssetSprite
---		@field locIdOverride string
---		@field hiddenInItemBar boolean
---		@field showBuildingPreview boolean
---		@field isMultiSelectable boolean
---		@field isFloatable boolean
---		@field colorItem Color
---		@field colorWorld_itemRate number
---		@field colorGroundSpecific Color
---		@field colorGroundSpecificRate number
---		@field colorGroundSpecific2 Color
---		@field UVsSpecial number
---		@field forcedOrientation number
---		@field historyIgnore boolean
---		@field models CAssetModels
---		@field modelsAlt CAssetModels
---		@field modelsAlt2 CAssetModels
---		@field modelPreview CAssetModel
---		@field modelGlobal CAssetModel
---		@field previewAltitudeNeighboorsToCheck number[]
---		@field containersModels CAssetModelsContainers
---		@field containersDumpDestroyed number
---		@field containersModelsGenerated List<GameObject>
---		@field containersMeshes List<Mesh>
---		@field containersContentMeshes List<Mesh>
---		@field containerContentMat Material
---		@field isFavorite boolean
---		@field nbOwned number
---		@field nbOwnedMax number
---		@field nbProduced number
---		@field isFree boolean
---		@field localizedName string
---		@field localizedDesc string
---		@field localizedTooltip string
---		@field localisationUnused boolean
---		@field soundOnSelect CAssetSound
---		@field soundOnBuild CAssetSound

---	@class CItemCounter
---		@field valueMax number
---		@field bitOffset number

---	@class CItemData
---		@field bitOffset number
---		@field bitNb number
---		@field valueMax number

---	@class CItemUIGroup: CLuaEntity
---		@field icon CAssetSprite
---		@field showInItemBar boolean
---		@field showInItemBar_IfDevMode boolean
---		@field showInItemBar_IfCreative boolean
---		@field isDebug boolean
---		@field soundOnSelect CAssetSound
---		@field soundOnBuild CAssetSound

---	@class CItem_Content: CItem
---		@field is7Hex boolean
---		@field isDynamic boolean
---		@field sound CAssetSoundLooped
---		@field hideGroundModels number
---		@field isBuildableOnMountains boolean
---		@field isBuildableInWater boolean
---		@field isDestructibleAuto boolean
---		@field preventDrag boolean
---		@field preventDestroy boolean
---		@field damHeight number
---		@field upgradeOfItem CItem_Content
---		@field waterLevelStopBuildings number
---		@field preventDuplicate boolean

---	@class CItem_ContentBomb: CItem_Content

---	@class CItem_ContentCable: CItem_Content
---		@field dataCableType CItemData

---	@class CItem_ContentCity: CItem_Content
---		@field dataCityID CItemData
---		@field data7Hex CItemData
---		@field dataCityLabo CItemData
---		@field statusCity string[] default value = { "Selection_City_Detail_Status0", "Selection_City_Detail_Status1", "Selection_City_Detail_Status2", }

---	@class CItem_ContentCityDead: CItem_Content
---		@field data7Hex CItemData
---		@field dataCityLabo CItemData

---	@class CItem_ContentCityInOut: CItem_ContentFactory
---		@field dataSecondarySupply CItemData
---		@field isOut boolean
---		@field statusInOut string[] default value = { "Selection_CityInOut_Supply0", "Selection_CityInOut_Supply1", "Selection_CityInOut_Supply2", }

---	@class CItem_ContentConstructionSite: CItem_ContentFactory

---	@class CItem_ContentDamPump: CItem_ContentDam
---		@field dataDirection CItemData
---		@field pumpSpeed number

---	@class CItem_ContentDepot: CItem_ContentStock
---		@field priorityMax number default value = 1023
---		@field priorityLow number default value = 340
---		@field priorityPerContainer number default value = 19
---		@field priorityPerHexDistanceFromConsumers number default value = 20
---		@field dataPriority CItemData
---		@field dataSecondarySupply CItemData
---		@field dronesPosOffset Vector3[]
---		@field nbDrones number
---		@field range number
---		@field nbContainersPerDrone number
---		@field nbContainersMax number default value = 40

---	@class CItem_ContentDepotCreative: CItem_ContentDepot

---	@class CItem_ContentDump: CItem_ContentStock
---		@field defaultOldContentStock CItem_ContentStock
---		@field wastes CItem[]
---		@field dataOldContentStock CItemData

---	@class CItem_ContentDynamite: CItem_Content
---		@field progress CItemData
---		@field explode CItemData
---		@field itemPileOfDirt CItem
---		@field fuseDelay number
---		@field mountainApparitionDelay number
---		@field altitudeMin number

---	@class CItem_ContentEasterEgg: CItem_Content

---	@class CItem_ContentExtractor: CItem_ContentStock
---		@field animSpeedWheel number
---		@field animArmSpeed number
---		@field animArmAngleMin number
---		@field animArmAngleMax number
---		@field dataProgress CItemData
---		@field dataArmAngle CItemData

---	@class CItem_ContentFactory: CItem_ContentStock
---		@field dataProgress CItemData
---		@field dataRecipe CItemData
---		@field producesOutputContainers boolean
---		@field keepFxWithOptionOff boolean
---		@field autoShowRecipePick boolean
---		@field recipes CRecipe[]

---	@class CItem_ContentFactoryGHG: CItem_ContentFactory

---	@class CItem_ContentFarm: CItem_ContentSilo
---		@field nbHarvestPerYear number default value = 2
---		@field rangeFields number
---		@field plantingCooldownInitial number
---		@field plantingCooldownMin number
---		@field plantingCooldownMax number
---		@field plantingCost number
---		@field harvestReward number
---		@field itemField CItem_ContentField

---	@class CItem_ContentField: CItem_Content
---		@field LocFertilityReasons string[]
---		@field farmRange number
---		@field tempMin0 number
---		@field tempMin1 number
---		@field tempMax1 number
---		@field tempMax0 number
---		@field waterMin0 number
---		@field waterMin1 number
---		@field waterMax1 number
---		@field waterMax0 number
---		@field oxygenMin0 number
---		@field oxygenMin1 number
---		@field colorsWorldFarm Color[]
---		@field dataAge CItemData
---		@field dataAbandonned CItemData

---	@class CItem_ContentFlattenTerrain: CItem_Content
---		@field isLevelingTerrain boolean

---	@class CItem_ContentForest: CItem_Content
---		@field modelsYoungSummer CAssetModels
---		@field modelsYoungWinter CAssetModels
---		@field modelsFall CAssetModels
---		@field modelsWinter CAssetModels
---		@field modelsSpring CAssetModels
---		@field modelsDead CAssetModels
---		@field dataAge CItemData
---		@field dataDamages CItemData
---		@field dataState CItemData
---		@field dataIsClearing CItemData
---		@field density number
---		@field lifeConditions CLifeConditions
---		@field durationToGrowAdult number
---		@field durationToDisapear number
---		@field badConditionSpeedMult number
---		@field durationToSpread number
---		@field damagesFallToWinter number default value = 6
---		@field damagesToDeath number default value = 25
---		@field ageBaby number default value = 10
---		@field spawnGrass boolean
---		@field nbTreeO2 number

---	@class CItem_ContentIceExtractor: CItem_ContentFactory
---		@field dataAnimationStep CItemData

---	@class CItem_ContentLabo: CItem_ContentFactory
---		@field laboIndex number

---	@class CItem_ContentLandmark: CItem_Content

---	@class CItem_ContentLua: CItem_Content
---		@field FillSelectionUI_lua DynValue
---		@field Update01s_lua DynValue
---		@field Update_IfVisible_lua DynValue
---		@field Update_TryToBuild_lua DynValue
---		@field Update_IfSelected_lua DynValue
---		@field Update_IfGlobal_lua DynValue
---		@field Update10s_Planet_lua DynValue
---		@field SpawnContentModels_lua DynValue
---		@field RefreshTexts_lua DynValue
---		@field OnSelectItem_lua DynValue
---		@field OnSelectItemInItemBar_lua DynValue
---		@field OnUnselectItem_lua DynValue
---		@field OnUnselectItemInItemBar_lua DynValue
---		@field OnNewlyVisible_lua DynValue
---		@field OnDrag_lua DynValue
---		@field OnLoadDynamic_lua DynValue
---		@field IsSelectable_lua DynValue
---		@field IsBuildable_lua DynValue
---		@field Init_lua DynValue
---		@field InitGlobal_lua DynValue
---		@field InitLate_lua DynValue
---		@field GetColorWorld_lua DynValue
---		@field GetColorGroundMesh_lua DynValue
---		@field GenerateItemBuildingMesh_lua DynValue

---	@class CItem_ContentNei: CItem_Content
---		@field dataNei CItemData

---	@class CItem_ContentPileOfDirt: CItem_Content
---		@field addedAltitude number

---	@class CItem_ContentPumpingStation: CItem_ContentFactory
---		@field dataAnimationStep CItemData

---	@class CItem_ContentShield: CItem_Content
---		@field range number

---	@class CItem_ContentSilo: CItem_ContentStock
---		@field rangeSilos number
---		@field itemIn CItem_Intermediary
---		@field itemOut CItem_Intermediary
---		@field itemIn_NbMax number
---		@field itemOut_NbMax number
---		@field loadingSpeed number
---		@field balanceSpeed number

---	@class CItem_ContentSpaceLift: CItem_ContentFactory
---		@field brokenSpacelift CItem_ContentSpaceLiftBroken

---	@class CItem_ContentSpaceLiftBroken: CItem_Content
---		@field dataBrokenProgress CItemData
---		@field cable CItem_ContentCable

---	@class CStackInfos
---		@field nbMax number
---		@field angle number
---		@field pos Vector3

---	@class CItem_ContentStock: CItem_Content
---		@field stacksInfos CStackInfos[]

---	@class CItem_CreativeInstantAction: CItem_Content
---		@field waterAdded number
---		@field waterRange number
---		@field cityCreated boolean
---		@field cityRemoved boolean
---		@field popChanged_Mod number
---		@field bomb boolean
---		@field shiftMultiplier number
---		@field setMountainType number

---	@class CItem_CreativeOnUpdate: CItem_Content
---		@field waterAdded number
---		@field range number

---	@class CItem_CreativePaintGround: CItem_Content
---		@field itemGround CItem_Ground
---		@field range number

---	@class CItem_Greenhousegas: CItem

---	@class CItem_Ground: CItem
---		@field sound CAssetSoundLooped
---		@field soundWithIce CAssetSoundLooped
---		@field decoPeriod number

---	@class CItem_GroundDirt: CItem_Ground

---	@class CItem_GroundGrass: CItem_GroundDirt
---		@field lifeConditions CLifeConditions
---		@field qualityTemp0 number
---		@field qualityTemp1 number
---		@field qualityWaterLog0 number
---		@field qualityWaterLog1 number
---		@field nbTreeO2 number

---	@class CItem_GroundMineral: CItem_Ground
---		@field quantityMax number
---		@field quantityMax_WithOption number
---		@field colorWorld_itemRate_min number
---		@field displayMediumRatio number
---		@field displayLowRatio number

---	@class CItem_GroundMountain: CItem_Ground
---		@field colorGroundSpecific_deltaSlope number
---		@field colorWorld_itemRate_min number
---		@field colorWorld_itemRate_deltaSlope number
---		@field followSlope boolean
---		@field sizeMax_Max number
---		@field groupableIn7Hexes boolean

---	@class CItem_Intermediary: CItem

---	@class CItem_TerrainTool: CItem_Content
---		@field upOffset number
---		@field costDynamite number
---		@field costPileOfDirt number
---		@field itemDynamite CItem
---		@field itemPileOfDirt CItem
---		@field soundOnStartModify CAssetSound
---		@field soundOnMove CAssetSound
---		@field soundOnApply CAssetSound

---	@class CItem_Vehicle: CItem
---		@field wayType number
---		@field wayDefault CItem_Way
---		@field nbStacks number
---		@field nbContainersPerStack number
---		@field canUTurn boolean
---		@field sound CAssetSoundLooped
---		@field soundDeparture CAssetSound
---		@field speedMax number
---		@field speedMedium number
---		@field speedLow number
---		@field acceleration number
---		@field accelerationBraking number
---		@field distStopRegistration number
---		@field nbContainersPerYearComputedMax number
---		@field durationWagonLoad number
---		@field durationLoadWait number
---		@field distSideWay number
---		@field rideOnNeighbors boolean
---		@field altitudeAboveWay number
---		@field wagonLength number
---		@field frontTargetDist number
---		@field containerOffset Vector3
---		@field totalLength number
---		@field uTurnDistance number
---		@field wayWaterMax number
---		@field wayShip CItem_WayShip
---		@field isVisibleIntermediary boolean
---		@field containerShipStack boolean
---		@field sinkStacksEmpty number
---		@field sinkStacksFull number
---		@field rerouteCooldown number
---		@field achievementRef CAchievement

---	@class CItem_Water: CItem_Content
---		@field quantity number
---		@field range number

---	@class CItem_Way: CItem_Content
---		@field dataBridgeHeight CItemData
---		@field bridgeHeightStep number default value = 20
---		@field wayTypes number
---		@field scaleY number
---		@field isBuiltAsALine boolean
---		@field isRoundabout boolean

---	@class CItem_WayCross: CItem_Way

---	@class CItem_WayShip: CItem_Way
---		@field buoyVisible CItemData

---	@class CItem_WayStop: CItem_Way
---		@field itemVehicle CItem_Vehicle
---		@field dataVehicleRegisteredId CItemData
---		@field dataDirection CItemData
---		@field dataOriginEnd CItemData
---		@field modelsSignal CAssetModels
---		@field hasWayPath boolean

---	@class CLifeConditions
---		@field waterMin number
---		@field waterMax number
---		@field temperatureMin number
---		@field temperatureMax number
---		@field temperatureGrow number
---		@field waterProximityMin number
---		@field waterProximityMax number

---	@class CRecipe: CLuaEntity
---		@field inputs List<CRecipeElement>
---		@field outputs List<CRecipeElement>
---		@field duration number
---		@field cityPop number

---	@class angles: ValueType
---		@field alpha number
---		@field beta number
---		@field radius number

---	@class int2: ValueType
---		@field x number
---		@field y number
---		@field zero int2 default value = int2<a href="/tp 0 0"><color=cyan>(0, 0)</color></a>
---		@field minValue int2 default value = int2<a href="/tp -2147483648 -2147483648"><color=cyan>(-2147483648, -2147483648)</color></a>
---		@field maxValue int2 default value = int2<a href="/tp 2147483647 2147483647"><color=cyan>(2147483647, 2147483647)</color></a>
---		@field up int2 default value = int2<a href="/tp 0 1"><color=cyan>(0, 1)</color></a>
---		@field right int2 default value = int2<a href="/tp 1 0"><color=cyan>(1, 0)</color></a>
---		@field one int2 default value = int2<a href="/tp 1 1"><color=cyan>(1, 1)</color></a>
---		@field negative int2 default value = int2<a href="/tp -1 -1"><color=cyan>(-1, -1)</color></a>
---		@field negativeFar int2 default value = int2<a href="/tp -10000 -10000"><color=cyan>(-10000, -10000)</color></a>

---	@class UISelection
---		@field active boolean
---		@field rootGO GameObject

---	@class UISelection_BuildMode: UISelection
---		@field mirror Button
---		@field rotate Button

---	@class UISelection_Button: UISelection
---		@field button Button
---		@field buttonText Text
---		@field tooltip CTooltipTarget

---	@class UISelection_ButtonFollowCamera: UISelection
---		@field button Button

---	@class UISelection_ButtonToggle: UISelection
---		@field toggle Toggle
---		@field text Text
---		@field tooltip CTooltipTarget

---	@class UISelection_ButtonToggleSubtext: UISelection
---		@field toggle Toggle
---		@field text Text
---		@field subText Text
---		@field tooltip CTooltipTarget
---		@field shortcut Text

---	@class UISelection_DropdownList: UISelection
---		@field title Text
---		@field dropdown Dropdown

---	@class UISelection_Input: UISelection
---		@field text Text
---		@field input InputField

---	@class UISelection_Item: UISelection
---		@field uiItem CUiItem
---		@field shortcut Text

---	@class UISelection_ItemList: UISelection
---		@field cUiItemList CUiItemList

---	@class UISelection_ProductionStats: UISelection
---		@field parent Transform
---		@field prefabStatLine CUiStatLine
---		@field background Transform
---		@field finishedProductsParent Transform
---		@field finishedProductRef GameObject
---		@field colorTextTitle Color
---		@field colorTextItem Color

---	@class UISelection_ProgressBar: UISelection
---		@field text Text
---		@field slider RectMask2D
---		@field bar Transform

---	@class UISelection_Recipe: UISelection
---		@field uiRecipe CUiRecipe
---		@field shortcut Text

---	@class UISelection_Rotate: UISelection
---		@field buttonClockwise Button
---		@field buttonCounterClockwise Button
---		@field tooltipClockwise CTooltipTarget
---		@field tooltipCounterClockwise CTooltipTarget

---	@class UISelection_SelectionCommon: UISelection
---		@field copy Button
---		@field cut Button
---		@field delete Button
---		@field exportToClipboard Button

---	@class UISelection_TerrainTool: UISelection
---		@field buildMode ToggleGroup
---		@field effectMode ToggleGroup
---		@field toggleFlatten Toggle
---		@field toggleRamp Toggle
---		@field toggleSmooth Toggle
---		@field effectRadius Slider
---		@field borderRadius Slider
---		@field altitude Slider
---		@field altitudeDisabled GameObject
---		@field labelEffectRadiusValue Text
---		@field labelBorderRadiusValue Text
---		@field labelAltitudeValue Text
---		@field costDynamite CUiItemTerrainToolCost
---		@field costPileOfDirt CUiItemTerrainToolCost

---	@class UISelection_TextAdditional: UISelection
---		@field text Text
---		@field tooltipTarget CTooltipTarget

---	@class UISelection_ValueModifiable: UISelection
---		@field icon Image
---		@field text Text
---		@field buttonRemove Button
---		@field buttonAdd Button
---		@field tooltipButtonAdd CTooltipTarget

---	@class UISelection_Vehicles: UISelection
---		@field btInverse Button
---		@field btRefresh Button
---		@field btDestroy Button
---		@field btSetStart Button
---		@field btSetEnd Button
---		@field textSetStart Text
---		@field textSetEnd Text
---		@field btLocateStart Button
---		@field btLocateEnd Button

---	@class SWorld_GenerationLua: SSingleton<SWorld_GenerationLua>

---	@class FaceElements: ValueType
---		@field face CAssetSprite
---		@field mouth CAssetSprite
---		@field eyes CAssetSprite

---	@class CRecipeElement
---		@field item CItem
---		@field nb number

---	@class UI: ValueType
---		@field rootPanel GameObject
---		@field titleText Text
---		@field titleCloseButton Button
---		@field descIconBG Image
---		@field descIcons List<Image>
---		@field descIconGrid GridLayoutGroup
---		@field descText Text
---		@field warningText Text
---		@field textAdditional UISelection_TextAdditional
---		@field progress UISelection_ProgressBar
---		@field item UISelection_Item
---		@field buttonToggle UISelection_ButtonToggle
---		@field buttonToggleSubtext UISelection_ButtonToggleSubtext
---		@field button UISelection_Button
---		@field uiRecipeNew UISelection_Recipe
---		@field valueModifiable UISelection_ValueModifiable
---		@field vehicles UISelection_Vehicles
---		@field input UISelection_Input
---		@field rotate UISelection_Rotate
---		@field itemList UISelection_ItemList
---		@field buttonFollowCamera UISelection_ButtonFollowCamera
---		@field dropdownList UISelection_DropdownList
---		@field selectionCommon UISelection_SelectionCommon
---		@field buildMode UISelection_BuildMode
---		@field terrainTool UISelection_TerrainTool
---		@field prodStats UISelection_ProductionStats

